/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpMutex.c,v 1.3.4.3 2001/06/01 21:20:20 marcd Exp $
____________________________________________________________________________*/
#include <stdio.h>
#include "pgpThreads.h"

#if PGP_UNIX_SOLARIS

/* ARGSUSED */
int
PGPMutexCreate( PGPMutex_t *mp, PGPMutexAttr_t *attr )
{
	return( mutex_init( mp, attr ? *attr : USYNC_THREAD, NULL ) );
}

int
PGPMutexDestroy( PGPMutex_t *mp )
{
	return( mutex_destroy( mp ) );
}

int
PGPMutexLock( PGPMutex_t *mp )
{
	return( mutex_lock( mp ) );
}

int
PGPMutexUnlock( PGPMutex_t *mp )
{
	return( mutex_unlock( mp ) );
}

int
PGPMutexTryLock( PGPMutex_t *mp )
{
	return( mutex_trylock( mp ) );
}
#endif /* PGP_UNIX_SOLARIS */

#if HAVE_PTHREAD_CREATE

/* ARGSUSED */
int
PGPMutexCreate( PGPMutex_t *mp, PGPMutexAttr_t *attr )
{
	return( pthread_mutex_init(mp, attr) );
}

int
PGPMutexDestroy( PGPMutex_t *mp )
{
	return( pthread_mutex_destroy( mp ) );
}

int
PGPMutexLock( PGPMutex_t *mp )
{
	return( pthread_mutex_lock( mp ) );
}

int
PGPMutexUnlock( PGPMutex_t *mp )
{
	return( pthread_mutex_unlock( mp ) );
}

int
PGPMutexTryLock( PGPMutex_t *mp )
{
	return( pthread_mutex_trylock( mp ) );
}

#endif /* HAVE_PTREAD_CREATE */

#if PGP_WIN32

#include <process.h>
#include <windows.h>

/* ARGSUSED */
int
PGPMutexCreate( PGPMutex_t *mp, PGPMutexAttr_t *attr )
{

	*mp = CreateMutex(NULL, FALSE, NULL);
	
	return( *mp == NULL );
}

int
PGPMutexDestroy( PGPMutex_t *mp )
{
	int	lRC = CloseHandle(*mp);
	return(lRC == 0);
}

int
PGPMutexLock( PGPMutex_t *mp )
{
	int	lRC = WaitForSingleObject(*mp, INFINITE);
	
	return(lRC == WAIT_FAILED);
}

int
PGPMutexUnlock( PGPMutex_t *mp )
{
	int	lRC = ReleaseMutex(*mp);
	return(lRC == 0);
}

int
PGPMutexTryLock( PGPMutex_t *mp )
{
	int	lRC = WaitForSingleObject(*mp, 0);
	
	return(lRC == WAIT_TIMEOUT);
}

#endif /* PGP_WIN32 */

/* If all else fails, try to create a mutex out of a semget binary
   semaphore. */

#if !defined(_PGP_THREAD) && HAVE_SEMGET

#include <sys/stat.h>

/* ARGSUSED */
int
PGPMutexCreate( PGPMutex_t *mp, PGPMutexAttr_t *attr )
{
	PGPSemAttr_t	SemAttr;
	int		rc;

	SemAttr.type = IPC_CREAT | IPC_EXCL | S_IRUSR | S_IWUSR;
	SemAttr.nsems = 1;

	rc = PGPSemCreate((PGPSem_t *) mp, &SemAttr);
        if (rc >= 0)
		PGPSemPost((PGPSem_t *) mp);
	return rc;
}

int
PGPMutexDestroy( PGPMutex_t *mp )
{
	return (PGPSemDestroy((PGPSem_t *)mp));
}

int
PGPMutexLock( PGPMutex_t *mp )
{
	return (PGPSemWait((PGPSem_t *)mp));
}

int
PGPMutexUnlock( PGPMutex_t *mp )
{
	return (PGPSemPost((PGPSem_t *)mp));
}

int
PGPMutexTryLock( PGPMutex_t *mp )
{
	return (PGPSemTryWait((PGPSem_t *)mp));
}

#endif /* !_PGP_THREAD && HAVE_SEMGET */


#if !defined(_PGP_THREAD) && !HAVE_SEMGET

/* ARGSUSED */
int
PGPMutexCreate( PGPMutex_t *mp, PGPMutexAttr_t *attr )
{
	return( 0 );
}

/* ARGSUSED */
int
PGPMutexDestroy( PGPMutex_t *mp )
{
	return( 0 );
}

/* ARGSUSED */
int
PGPMutexLock( PGPMutex_t *mp )
{
	return( 0 );
}

/* ARGSUSED */
int
PGPMutexUnlock( PGPMutex_t *mp )
{
	return( 0 );
}

/* ARGSUSED */
int
PGPMutexTryLock( PGPMutex_t *mp )
{
	return( 0 );
}

#endif /* no thread package */
